// Autor: Ante Derek

#include <iostream>
#include <map>

using namespace std;

map<string, int> I;

int index(const string &s) {
  if (I.count(s))
    return I[s];
  int next = (int)I.size();
  I[s] = next;
  return next;
}

const int MAX = 20;

int n;
int m;
int g[MAX][MAX];
int h[MAX][MAX];

int count(int k) {
  for (int i=0; i<n; i++)
    for (int j=0; j<n; j++)
      h[i][j] = g[i][j];
  
  for (int i=0; i<n; i++)
    for (int j=i+1; j<n; j++)
      if (i != k && j != k && g[i][k] && g[j][k] && !g[i][j])
        h[i][j] = h[j][i] = 1;

  int cnt = 0;
  for (int i=0; i<n; i++)
    for (int j=i+1; j<n; j++)
      for (int k=j+1; k<n; k++)
        if (h[i][j] && h[j][k] && h[i][k])
          cnt++;

  return cnt;
}

int main() {
  cin >> n >> m;
  for (int i=0; i<n; i++)
    for (int j=0; j<n; j++)
      g[i][j] = 0;
  for (int i=0; i<m; i++) {
    string a, b;
    cin >> a >> b;
    int ai = index(a);
    int bi = index(b);
    g[ai][bi] = g[bi][ai] = 1;
  }
  for (auto x : I) {
    cout << x.first << " " << count(x.second) << endl;
  }
  return 0;
}
